init python:

    maxthumbx = config.screen_width / (5 + 1)
    maxthumby = config.screen_height / (4 + 1)

    replay_page = 0

    class ReplayItem:
        def __init__(self, thumbs, replay):
            self.thumbs = thumbs
            self.replay = replay

        def num_replay(self):
            return len(self.thumbs)

    Replay_items = []
    Replay_items.append(ReplayItem(["Rthumb1"], "r_1"))
    Replay_items.append(ReplayItem(["Rthumb2"], "r_2"))
    Replay_items.append(ReplayItem(["Rthumb3"], "r_3"))
    Replay_items.append(ReplayItem(["Rthumb4"], "r_4"))
    Replay_items.append(ReplayItem(["Rthumb5"], "day3red"))
    Replay_items.append(ReplayItem(["Rthumb6"], "r_6"))
    Replay_items.append(ReplayItem(["Rthumb7"], "r_7"))
    Replay_items.append(ReplayItem(["Rthumb8"], "r_8"))
    Replay_items.append(ReplayItem(["Rthumb9"], "r_9"))
    Replay_items.append(ReplayItem(["Rthumb10"], "r_10"))
    Replay_items.append(ReplayItem(["Rthumb11"], "r_11"))
    Replay_items.append(ReplayItem(["Rthumb12"], "d6_sophie"))
    Replay_items.append(ReplayItem(["Rthumb13"], "r_12"))
    Replay_items.append(ReplayItem(["Rthumb14"], "d8sophie"))
    Replay_items.append(ReplayItem(["Rthumb15"], "d8_les_content"))
    Replay_items.append(ReplayItem(["Rthumb16"], "d8_bo"))
    Replay_items.append(ReplayItem(["Rthumb17"], "d8_sroom"))
    Replay_items.append(ReplayItem(["Rthumb18"], "d9_bo_morn"))

transform imageThumb:
    size(240, 135)

style gallery_button:
# hover overlay it must be 4 pixels bigger then the images
    hover_foreground "gallery/replay/hover_244x139.png" 

image locked = ("gallery/2/locked_3.png")
image Rthumb1 = ("gallery/replay/r1.jpg")
image Rthumb2 = ("gallery/replay/r2.jpg")
image Rthumb3 = ("gallery/replay/r3.jpg")
image Rthumb4 = ("gallery/replay/r4.jpg")
image Rthumb5 = ("gallery/replay/r5.jpg")
image Rthumb6 = ("gallery/replay/r6.jpg")
image Rthumb7 = ("gallery/replay/r7.jpg")
image Rthumb8 = ("gallery/replay/r8.jpg")
image Rthumb9 = ("gallery/replay/r9.jpg")
image Rthumb10 = ("gallery/replay/r10.jpg")
image Rthumb11 = ("gallery/replay/r11.jpg")
image Rthumb12 = ("gallery/replay/r12.jpg")
image Rthumb13 = ("gallery/replay/r13.jpg")
image Rthumb14 = ("gallery/replay/r14.jpg")
image Rthumb15 = ("gallery/replay/r15.jpg")
image Rthumb16 = ("gallery/replay/r16.jpg")
image Rthumb17 = ("gallery/replay/r17.jpg")
image Rthumb18 = ("gallery/replay/r18.jpg")


screen Replayexit():
    zorder 100
    imagebutton auto "mobile/menus/exit_%s.png" action EndReplay() yalign .01 xalign .99

screen gallery_replay():
    tag menu
    modal True

    $start = replay_page * 20
    $end = min(start + 20 - 1, len(Replay_items) - 1)

    add "gallery_bg"
    add "gui/phone/replay.png" xpos 650 ypos 35
    imagebutton:
        xalign 0.99
        yalign 0.01
        auto "mobile/menus/exit_%s.png"
        action [Hide("gallery_replay"), Show("main_menu")]

    grid 5 4: 
        spacing 20
        yalign 0.50
        xalign 0.50
        for i in range(start, end + 1):
            if renpy.seen_label(Replay_items[i].replay):
                imagebutton:
                    idle Replay_items[i].thumbs
                    style "gallery_button" #delete this line to remove hover
                    action Replay(Replay_items[i].replay)
                    xalign 0.5
                    yalign 0.5
                    at imageThumb
            else:
                vbox xalign 0.5 yalign 0.5:
                    image "locked"
                    at imageThumb
        #required to fill in empty grid items (do not change)
        for i in range(end - start + 1, 20):
            null

    #previous/next buttons
    if replay_page > 0:
        imagebutton:
            auto "images/freeroam/galleryleft_%s.png"
            action SetVariable("replay_page", replay_page - 1)
            xalign 0.1
            yalign 0.5
            #background "#000"
    if (replay_page + 1) * 20 < len(Replay_items):
        imagebutton:
            auto "images/freeroam/galleryright_%s.png"
            action SetVariable("replay_page", replay_page + 1)
            xalign 0.9
            yalign 0.5
            #background "#000"