init -5 python:

    class Credit:

        def __init__(self, name, role, image_name):            
            self.name = name
            self.role = role
            self.image_name = image_name 


    class CategorisedCredits:

        def __init__(self, category, credit_list):            
            self.category = category
            self.credit_list = credit_list

style about_header:
    size 60

style credits_category_header:
    size 50

style credits_url_button is text_button

#########################################################################################################################    

# style definitions only used by template 2

style credits_name_small:
    size 25
    bold True

style credits_role_small:
    size 20

# inherit from hyperlink_text
style credits_url_text_small is hyperlink_text
style credits_url_text_small:
    size 15

# Credits Screen 
screen credits():
    tag menu

    use game_menu(_(""), scroll="viewport"):

        style_prefix "about"

        text "Credits:" style "about_header" 
        null height 100 # manual vertical spacing

        # Iterate over the categories
        for categorised_credits in categorised_credits_list:

            # Header for the credits category
            text categorised_credits.category style "credits_category_header" 
            null height 50 # manual vertical spacing

            # syntax: grid <amount_columns> <amount_rows>
            # vpgrid is also an option over grid depending on preference.
            # As fas as I know, you can't give fixed coordinates to grid slots, positions are calculated for slots in relation to each other.
            # Such as having long text strings in first column will push the second column more to the right. Play around with xspacing value for the look you want.

            $ amount_credits = len(categorised_credits.credit_list)
            $ is_odd = amount_credits % 2 == 1

            # // is floor division
            if is_odd:
                $ rows = amount_credits // 2 + 1
            else:
                $ rows = amount_credits // 2

            grid 2 rows:            
                xspacing 100
                yspacing 100

                for credit in categorised_credits.credit_list:
                    hbox:
                        if credit.image_name is not None:
                            add credit.image_name zoom 0.6
                        else:
                            null width 150 # image width in px 
                            null height 150 # image height in px 

                        # distance between logo and text
                        null width 25 

                        vbox:
                            null height 5 # yalign 0.5 is an alternative option, but yalign is more suited when there is equal amount of elements in this vbox
                            text credit.name style "credits_name_small"
                            null height 10
                            text credit.role style "credits_role_small"
                            null height 10

                # exited for-loop, check if 'null' is necessary to fill up empty space (when elements number is not even)
                if is_odd:
                    null

            null height 100 # manual vertical spacing

############################################################################################################################################

define dev_credits_list = [
    Credit(name = "Badger", role = "Whispering Eye Games", image_name = None)
]

define playtest_credits_list = [
    Credit(name = "Alven", role = "", image_name = None),
    Credit(name = "Vortex", role = "", image_name = None),
]

define code_credits_list = [
    Credit(name = "BadMustard", role = "Phone and replay gallery", image_name = None),
    Credit(name = "Gaming Variety Potato", role = "Credits page", image_name = None),
    Credit(name = "NingNing", role = "Rewards gallery", image_name = None),
]

define audio_credits_list = [
    Credit(name = "Composer Squad", role = "Background music", image_name = None),
]

define sfx_credits_list = [
    Credit(name = "Apex Adult Audio", role = "", image_name = None),
    Credit(name = "FreeSound", role = "", image_name = None),
    Credit(name = "Zonk Punch", role = "", image_name = None),
    Credit(name = "Chiyo1000Nights", role = "OpenNSFW", image_name = None),
    Credit(name = "LeHornySFX3D", role = "OpenNSFW", image_name = None),
]

define va_credits_list = [
    Credit(name = "Chiyoru", role = "OpenNSFW", image_name = None),
    Credit(name = "Gemini Starsign", role = "OpenNSFW", image_name = None),
    Credit(name = "Kaya", role = "OpenNSFW", image_name = None),
    Credit(name = "MagicalMysticVA", role = "OpenNSFW", image_name = None),
    Credit(name = "Rain", role = "OpenNSFW", image_name = None),
]

define other_credits_list = [
    Credit(name = "Canva", role = "Game logo", image_name = None),
    Credit(name = "game-icons.net", role = "Phone icons", image_name = None),
    Credit(name = "Pexels", role = "TV images", image_name = None),
    Credit(name = "Ren'Py", role = "Game engine", image_name = None),
]

define patron_credits_list = [
    Credit(name = "My Patrons", role = "For supporting this project.", image_name = None),
    Credit(name = "You", role = "For playing.", image_name = None),
]

define categorised_credits_list = [

    CategorisedCredits(category = "Developer", credit_list = dev_credits_list),

    CategorisedCredits(category = "Playtesters", credit_list = playtest_credits_list),

    CategorisedCredits(category = "Used code from", credit_list = code_credits_list),

    CategorisedCredits(category = "Music", credit_list = audio_credits_list),

    CategorisedCredits(category = "Sound effects", credit_list = sfx_credits_list),

    CategorisedCredits(category = "Voice actors", credit_list = va_credits_list),

    CategorisedCredits(category = "Other", credit_list = other_credits_list),

    CategorisedCredits(category = "Special thanks to", credit_list = patron_credits_list),
]



